﻿// Test API
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TestController : ControllerBase
    {
        [HttpGet]
        public string Sum(string num1, string num2)
        {
            int num1Length = num1.Length;
            int num2Length = num2.Length;
            int maxLength = Math.Max(num1Length, num2Length);
            num1 = num1.PadLeft(maxLength, '0');
            num2 = num2.PadLeft(maxLength, '0');
            int sum = 0, ans = 0;
            string result = string.Empty;
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i <= maxLength; i++)
            {
                sum = num1[maxLength - i] - '0' + num2[maxLength - i] - '0' + ans;
                if (sum >= 10)
                {
                    sum = sum % 10;
                    ans = 1;
                }
                else
                {
                    ans = 0;
                }
                sb.Append(sum);
            }
            if (ans == 1)
            {
                sb.Append(1);
            }
            result = string.Join("", sb.ToString().Reverse());
            return result;
        }

        [HttpGet("{str}")]
        public string Copy(string str)
        {
            return str;
        }
    }

// Value API
    [Route("api/[controller]")]
    [ApiController]
    public class ValuesController : ControllerBase
    {
        // GET: api/<ValuesController>
        [HttpGet]
        public IEnumerable<string> Get()
        {
            return new string[] { "value1", "value2" };
        }

        // GET api/<ValuesController>/5
        [HttpGet("{id}")]
        public string Get(int id)
        {
            return (id * 2).ToString();
        }

        // POST api/<ValuesController>
        [HttpPost]
        public void Post([FromBody] string value)
        {
        }

        // PUT api/<ValuesController>/5
        [HttpPut("{id}")]
        public void Put(int id, [FromBody] string value)
        {
        }

        // DELETE api/<ValuesController>/5
        [HttpDelete("{id}")]
        public void Delete(int id)
        {
        }
    }